libname in 'G:\Public Use\Survey Data\CCD\State Fiscal (NPEFS)\NPEFS21\Final Version 2a';
*****************************************************************************************;
*       PROGRAM: stfis21_2a_SAS.sas                                                   *;
*          NOTE: 1) This program reads in the State Fiscal tab-delimited text data      *;
*                   file.                                                               *;
*                2) To create a permanent SAS data set, add a LIBNAME statement and     *;
*                   add the LIBNAME to the DATA statement.                              *;
*                3) Modify the path in the INFILE statement below to point to the       *;
*                   location of the text data file.                                     *;
*                4) Refer to the record layout file for detailed description of the     *;
*                   data elements, variable and value labels.                           *;
*   PROVIDED BY: National Center for Education Statistics                               *;
*   LAST UPDATED: Tuesday, December 19, 2023                                                     *;
*****************************************************************************************;
      data in.stfis21_2a                         ;
     %let _EFIERR_ = 0; /* set the ERROR detection macro variable */
     infile 'G:\Public Use\Survey Data\CCD\State Fiscal (NPEFS)\NPEFS21\Final Version 2a\stfis21_2a.txt'
 delimiter='09'x MISSOVER DSD lrecl=32767 firstobs=2 ;
 
         informat  SURVYEAR  best32. ;
         informat  FIPS  $2. ;
         informat  STABR  $2. ;
         informat  STNAME  $25. ;
         informat  R1A  best32. ;
         informat  R1B  best32. ;
         informat  R1C  best32. ;
         informat  R1D  best32. ;
         informat  R1E  best32. ;
         informat  R1F  best32. ;
         informat  R1G  best32. ;
         informat  R1H  best32. ;
         informat  R1I  best32. ;
         informat  R1J  best32. ;
         informat  R1K  best32. ;
         informat  R1L  best32. ;
         informat  R1M  best32. ;
         informat  R1N  best32. ;
         informat  STR1  best32. ;
         informat  R2  best32. ;
         informat  R3  best32. ;
         informat  R4A  best32. ;
         informat  R4B  best32. ;
         informat  R4C  best32. ;
         informat  R4D  best32. ;
         informat  STR4  best32. ;
         informat  R5  best32. ;
         informat  TR  best32. ;
         informat  E11  best32. ;
         informat  E12  best32. ;
         informat  E13  best32. ;
         informat  E14  best32. ;
         informat  E15  best32. ;
         informat  E16  best32. ;
         informat  E17  best32. ;
         informat  E18  best32. ;
         informat  STE1  best32. ;
         informat  E11A  best32. ;
         informat  E11B  best32. ;
         informat  E11C  best32. ;
         informat  E11D  best32. ;
         informat  E2  best32. ;
         informat  E212  best32. ;
         informat  E213  best32. ;
         informat  E214  best32. ;
         informat  E215  best32. ;
         informat  E216  best32. ;
         informat  E217  best32. ;
         informat  E218  best32. ;
         informat  TE21  best32. ;
         informat  E222  best32. ;
         informat  E223  best32. ;
         informat  E224  best32. ;
         informat  E225  best32. ;
         informat  E226  best32. ;
         informat  E227  best32. ;
         informat  E228  best32. ;
         informat  TE22  best32. ;
         informat  E232  best32. ;
         informat  E233  best32. ;
         informat  E234  best32. ;
         informat  E235  best32. ;
         informat  E236  best32. ;
         informat  E237  best32. ;
         informat  E238  best32. ;
         informat  TE23  best32. ;
         informat  E242  best32. ;
         informat  E243  best32. ;
         informat  E244  best32. ;
         informat  E245  best32. ;
         informat  E246  best32. ;
         informat  E247  best32. ;
         informat  E248  best32. ;
         informat  TE24  best32. ;
         informat  E252  best32. ;
         informat  E253  best32. ;
         informat  E254  best32. ;
         informat  E255  best32. ;
         informat  E256  best32. ;
         informat  E257  best32. ;
         informat  E258  best32. ;
         informat  TE25  best32. ;
         informat  E262  best32. ;
         informat  E263  best32. ;
         informat  E264  best32. ;
         informat  E265  best32. ;
         informat  E266  best32. ;
         informat  E267  best32. ;
         informat  E268  best32. ;
         informat  TE26  best32. ;
         informat  STE22  best32. ;
         informat  STE23  best32. ;
         informat  STE24  best32. ;
         informat  STE25  best32. ;
         informat  STE26  best32. ;
         informat  STE27  best32. ;
         informat  STE28  best32. ;
         informat  STE2T  best32. ;
         informat  E3A11  best32. ;
         informat  E3A12  best32. ;
         informat  E3A13  best32. ;
         informat  E3A14  best32. ;
         informat  E3A2  best32. ;
         informat  E3A16  best32. ;
         informat  E3A1  best32. ;
         informat  E3B11  best32. ;
         informat  E3B12  best32. ;
         informat  E3B13  best32. ;
         informat  E3B14  best32. ;
         informat  E3B2  best32. ;
         informat  E3B16  best32. ;
         informat  E3B1  best32. ;
         informat  STE3  best32. ;
         informat  E4A1  best32. ;
         informat  E4A2  best32. ;
         informat  E4B1  best32. ;
         informat  E4B2  best32. ;
         informat  E4C1  best32. ;
         informat  E4C2  best32. ;
         informat  E4D  best32. ;
         informat  E4E1  best32. ;
         informat  E4E2  best32. ;
         informat  STE4  best32. ;
         informat  TE5  best32. ;
         informat  E61  best32. ;
         informat  E62  best32. ;
         informat  E63  best32. ;
         informat  STE6  best32. ;
         informat  E7A1  best32. ;
         informat  E7A2  best32. ;
         informat  STE7  best32. ;
         informat  E81  best32. ;
         informat  E82  best32. ;
         informat  E9A  best32. ;
         informat  E9B  best32. ;
         informat  E9C  best32. ;
         informat  E9D  best32. ;
         informat  E91  best32. ;
         informat  STE9  best32. ;
         informat  TE10  best32. ;
         informat  TE11  best32. ;
         informat  X12C  best32. ;
         informat  X12D  best32. ;
         informat  X12E  best32. ;
         informat  X12F  best32. ;
         informat  TX12  best32. ;
         informat  NCE13  best32. ;
         informat  ADA  best32. ;
         informat  A14A  best32. ;
         informat  A14B  best32. ;
         informat  PPE15  best32. ;
         informat  MEMBR20  best32. ;
         informat  CE1  best32. ;
         informat  CE2  best32. ;
         informat  AR1  best32. ;
         informat  AR1A  best32. ;
         informat  AR1B  best32. ;
         informat  AR2  best32. ;
         informat  AR2A  best32. ;
         informat  AR3  best32. ;
         informat  AR6  best32. ;
         informat  AR6A  best32. ;
         informat  AR7  best32. ;
         informat  AR8  best32. ;
         informat  AE1  best32. ;
         informat  AE2  best32. ;
         informat  AE3  best32. ;
         informat  AE4  best32. ;
         informat  AE5  best32. ;
         informat  AE6  best32. ;
         informat  AE7  best32. ;
         informat  AE8  best32. ;
         informat  IR1A  $1. ;
         informat  IR1B  $1. ;
         informat  IR1C  $1. ;
         informat  IR1D  $1. ;
         informat  IR1E  $1. ;
         informat  IR1F  $1. ;
         informat  IR1G  $1. ;
         informat  IR1H  $1. ;
         informat  IR1I  $1. ;
         informat  IR1J  $1. ;
         informat  IR1K  $1. ;
         informat  IR1L  $1. ;
         informat  IR1M  $1. ;
         informat  IR1N  $1. ;
         informat  ISTR1  $1. ;
         informat  IR2  $1. ;
         informat  IR3  $1. ;
         informat  IR4A  $1. ;
         informat  IR4B  $1. ;
         informat  IR4C  $1. ;
         informat  IR4D  $1. ;
         informat  ISTR4  $1. ;
         informat  IR5  $1. ;
         informat  ITR  $1. ;
         informat  IE11  $1. ;
         informat  IE12  $1. ;
         informat  IE13  $1. ;
         informat  IE14  $1. ;
         informat  IE15  $1. ;
         informat  IE16  $1. ;
         informat  IE17  $1. ;
         informat  IE18  $1. ;
         informat  ISTE1  $1. ;
         informat  IE11A  $1. ;
         informat  IE11B  $1. ;
         informat  IE11C  $1. ;
         informat  IE11D  $1. ;
         informat  IE2  $1. ;
         informat  IE212  $1. ;
         informat  IE213  $1. ;
         informat  IE214  $1. ;
         informat  IE215  $1. ;
         informat  IE216  $1. ;
         informat  IE217  $1. ;
         informat  IE218  $1. ;
         informat  ITE21  $1. ;
         informat  IE222  $1. ;
         informat  IE223  $1. ;
         informat  IE224  $1. ;
         informat  IE225  $1. ;
         informat  IE226  $1. ;
         informat  IE227  $1. ;
         informat  IE228  $1. ;
         informat  ITE22  $1. ;
         informat  IE232  $1. ;
         informat  IE233  $1. ;
         informat  IE234  $1. ;
         informat  IE235  $1. ;
         informat  IE236  $1. ;
         informat  IE237  $1. ;
         informat  IE238  $1. ;
         informat  ITE23  $1. ;
         informat  IE242  $1. ;
         informat  IE243  $1. ;
         informat  IE244  $1. ;
         informat  IE245  $1. ;
         informat  IE246  $1. ;
         informat  IE247  $1. ;
         informat  IE248  $1. ;
         informat  ITE24  $1. ;
         informat  IE252  $1. ;
         informat  IE253  $1. ;
         informat  IE254  $1. ;
         informat  IE255  $1. ;
         informat  IE256  $1. ;
         informat  IE257  $1. ;
         informat  IE258  $1. ;
         informat  ITE25  $1. ;
         informat  IE262  $1. ;
         informat  IE263  $1. ;
         informat  IE264  $1. ;
         informat  IE265  $1. ;
         informat  IE266  $1. ;
         informat  IE267  $1. ;
         informat  IE268  $1. ;
         informat  ITE26  $1. ;
         informat  ISTE22  $1. ;
         informat  ISTE23  $1. ;
         informat  ISTE24  $1. ;
         informat  ISTE25  $1. ;
         informat  ISTE26  $1. ;
         informat  ISTE27  $1. ;
         informat  ISTE28  $1. ;
         informat  ISTE2T  $1. ;
         informat  IE3A11  $1. ;
         informat  IE3A12  $1. ;
         informat  IE3A13  $1. ;
         informat  IE3A14  $1. ;
         informat  IE3A2  $1. ;
         informat  IE3A16  $1. ;
         informat  IE3A1  $1. ;
         informat  IE3B11  $1. ;
         informat  IE3B12  $1. ;
         informat  IE3B13  $1. ;
         informat  IE3B14  $1. ;
         informat  IE3B2  $1. ;
         informat  IE3B16  $1. ;
         informat  IE3B1  $1. ;
         informat  ISTE3  $1. ;
         informat  IE4A1  $1. ;
         informat  IE4A2  $1. ;
         informat  IE4B1  $1. ;
         informat  IE4B2  $1. ;
         informat  IE4C1  $1. ;
         informat  IE4C2  $1. ;
         informat  IE4D  $1. ;
         informat  IE4E1  $1. ;
         informat  IE4E2  $1. ;
         informat  ISTE4  $1. ;
         informat  ITE5  $1. ;
         informat  IE61  $1. ;
         informat  IE62  $1. ;
         informat  IE63  $1. ;
         informat  ISTE6  $1. ;
         informat  IE7A1  $1. ;
         informat  IE7A2  $1. ;
         informat  ISTE7  $1. ;
         informat  IE81  $1. ;
         informat  IE82  $1. ;
         informat  IE9A  $1. ;
         informat  IE9B  $1. ;
         informat  IE9C  $1. ;
         informat  IE9D  $1. ;
         informat  IE91  $1. ;
         informat  ISTE9  $1. ;
         informat  ITE10  $1. ;
         informat  ITE11  $1. ;
         informat  IX12C  $1. ;
         informat  IX12D  $1. ;
         informat  IX12E  $1. ;
         informat  IX12F  $1. ;
         informat  ITX12  $1. ;
         informat  INCE13  $1. ;
         informat  IADA  $1. ;
         informat  IA14A  $1. ;
         informat  IA14B  $1. ;
         informat  IPPE15  $1. ;
         informat  IMEMBR20  $1. ;
         informat  ICE1  $1. ;
         informat  ICE2  $1. ;
         informat  IAR1  $1. ;
         informat  IAR1A  $1. ;
         informat  IAR1B  $1. ;
         informat  IAR2  $1. ;
         informat  IAR2A  $1. ;
         informat  IAR3  $1. ;
         informat  IAR6  $1. ;
         informat  IAR6A  $1. ;
         informat  IAR7  $1. ;
         informat  IAR8  $1. ;
         informat  IAE1  $1. ;
         informat  IAE2  $1. ;
         informat  IAE3  $1. ;
         informat  IAE4  $1. ;
         informat  IAE5  $1. ;
         informat  IAE6  $1. ;
         informat  IAE7  $1. ;
         informat  IAE8  $1. ;
 
         format  SURVYEAR  best12. ;
         format  FIPS  $2. ;
         format  STABR  $2. ;
         format  STNAME  $25. ;
         format  R1A  best12. ;
         format  R1B  best12. ;
         format  R1C  best12. ;
         format  R1D  best12. ;
         format  R1E  best12. ;
         format  R1F  best12. ;
         format  R1G  best12. ;
         format  R1H  best12. ;
         format  R1I  best12. ;
         format  R1J  best12. ;
         format  R1K  best12. ;
         format  R1L  best12. ;
         format  R1M  best12. ;
         format  R1N  best12. ;
         format  STR1  best12. ;
         format  R2  best12. ;
         format  R3  best12. ;
         format  R4A  best12. ;
         format  R4B  best12. ;
         format  R4C  best12. ;
         format  R4D  best12. ;
         format  STR4  best12. ;
         format  R5  best12. ;
         format  TR  best12. ;
         format  E11  best12. ;
         format  E12  best12. ;
         format  E13  best12. ;
         format  E14  best12. ;
         format  E15  best12. ;
         format  E16  best12. ;
         format  E17  best12. ;
         format  E18  best12. ;
         format  STE1  best12. ;
         format  E11A  best12. ;
         format  E11B  best12. ;
         format  E11C  best12. ;
         format  E11D  best12. ;
         format  E2  best12. ;
         format  E212  best12. ;
         format  E213  best12. ;
         format  E214  best12. ;
         format  E215  best12. ;
         format  E216  best12. ;
         format  E217  best12. ;
         format  E218  best12. ;
         format  TE21  best12. ;
         format  E222  best12. ;
         format  E223  best12. ;
         format  E224  best12. ;
         format  E225  best12. ;
         format  E226  best12. ;
         format  E227  best12. ;
         format  E228  best12. ;
         format  TE22  best12. ;
         format  E232  best12. ;
         format  E233  best12. ;
         format  E234  best12. ;
         format  E235  best12. ;
         format  E236  best12. ;
         format  E237  best12. ;
         format  E238  best12. ;
         format  TE23  best12. ;
         format  E242  best12. ;
         format  E243  best12. ;
         format  E244  best12. ;
         format  E245  best12. ;
         format  E246  best12. ;
         format  E247  best12. ;
         format  E248  best12. ;
         format  TE24  best12. ;
         format  E252  best12. ;
         format  E253  best12. ;
         format  E254  best12. ;
         format  E255  best12. ;
         format  E256  best12. ;
         format  E257  best12. ;
         format  E258  best12. ;
         format  TE25  best12. ;
         format  E262  best12. ;
         format  E263  best12. ;
         format  E264  best12. ;
         format  E265  best12. ;
         format  E266  best12. ;
         format  E267  best12. ;
         format  E268  best12. ;
         format  TE26  best12. ;
         format  STE22  best12. ;
         format  STE23  best12. ;
         format  STE24  best12. ;
         format  STE25  best12. ;
         format  STE26  best12. ;
         format  STE27  best12. ;
         format  STE28  best12. ;
         format  STE2T  best12. ;
         format  E3A11  best12. ;
         format  E3A12  best12. ;
         format  E3A13  best12. ;
         format  E3A14  best12. ;
         format  E3A2  best12. ;
         format  E3A16  best12. ;
         format  E3A1  best12. ;
         format  E3B11  best12. ;
         format  E3B12  best12. ;
         format  E3B13  best12. ;
         format  E3B14  best12. ;
         format  E3B2  best12. ;
         format  E3B16  best12. ;
         format  E3B1  best12. ;
         format  STE3  best12. ;
         format  E4A1  best12. ;
         format  E4A2  best12. ;
         format  E4B1  best12. ;
         format  E4B2  best12. ;
         format  E4C1  best12. ;
         format  E4C2  best12. ;
         format  E4D  best12. ;
         format  E4E1  best12. ;
         format  E4E2  best12. ;
         format  STE4  best12. ;
         format  TE5  best12. ;
         format  E61  best12. ;
         format  E62  best12. ;
         format  E63  best12. ;
         format  STE6  best12. ;
         format  E7A1  best12. ;
         format  E7A2  best12. ;
         format  STE7  best12. ;
         format  E81  best12. ;
         format  E82  best12. ;
         format  E9A  best12. ;
         format  E9B  best12. ;
         format  E9C  best12. ;
         format  E9D  best12. ;
         format  E91  best12. ;
         format  STE9  best12. ;
         format  TE10  best12. ;
         format  TE11  best12. ;
         format  X12C  best12. ;
         format  X12D  best12. ;
         format  X12E  best12. ;
         format  X12F  best12. ;
         format  TX12  best12. ;
         format  NCE13  best12. ;
         format  ADA  best12. ;
         format  A14A  best12. ;
         format  A14B  best12. ;
         format  PPE15  best12. ;
         format  MEMBR20  best12. ;
         format  CE1  best12. ;
         format  CE2  best12. ;
         format  AR1  best12. ;
         format  AR1A  best12. ;
         format  AR1B  best12. ;
         format  AR2  best12. ;
         format  AR2A  best12. ;
         format  AR3  best12. ;
         format  AR6  best12. ;
         format  AR6A  best12. ;
         format  AR7  best12. ;
         format  AR8  best12. ;
         format  AE1  best12. ;
         format  AE2  best12. ;
         format  AE3  best12. ;
         format  AE4  best12. ;
         format  AE5  best12. ;
         format  AE6  best12. ;
         format  AE7  best12. ;
         format  AE8  best12. ;
         format  IR1A  $1. ;
         format  IR1B  $1. ;
         format  IR1C  $1. ;
         format  IR1D  $1. ;
         format  IR1E  $1. ;
         format  IR1F  $1. ;
         format  IR1G  $1. ;
         format  IR1H  $1. ;
         format  IR1I  $1. ;
         format  IR1J  $1. ;
         format  IR1K  $1. ;
         format  IR1L  $1. ;
         format  IR1M  $1. ;
         format  IR1N  $1. ;
         format  ISTR1  $1. ;
         format  IR2  $1. ;
         format  IR3  $1. ;
         format  IR4A  $1. ;
         format  IR4B  $1. ;
         format  IR4C  $1. ;
         format  IR4D  $1. ;
         format  ISTR4  $1. ;
         format  IR5  $1. ;
         format  ITR  $1. ;
         format  IE11  $1. ;
         format  IE12  $1. ;
         format  IE13  $1. ;
         format  IE14  $1. ;
         format  IE15  $1. ;
         format  IE16  $1. ;
         format  IE17  $1. ;
         format  IE18  $1. ;
         format  ISTE1  $1. ;
         format  IE11A  $1. ;
         format  IE11B  $1. ;
         format  IE11C  $1. ;
         format  IE11D  $1. ;
         format  IE2  $1. ;
         format  IE212  $1. ;
         format  IE213  $1. ;
         format  IE214  $1. ;
         format  IE215  $1. ;
         format  IE216  $1. ;
         format  IE217  $1. ;
         format  IE218  $1. ;
         format  ITE21  $1. ;
         format  IE222  $1. ;
         format  IE223  $1. ;
         format  IE224  $1. ;
         format  IE225  $1. ;
         format  IE226  $1. ;
         format  IE227  $1. ;
         format  IE228  $1. ;
         format  ITE22  $1. ;
         format  IE232  $1. ;
         format  IE233  $1. ;
         format  IE234  $1. ;
         format  IE235  $1. ;
         format  IE236  $1. ;
         format  IE237  $1. ;
         format  IE238  $1. ;
         format  ITE23  $1. ;
         format  IE242  $1. ;
         format  IE243  $1. ;
         format  IE244  $1. ;
         format  IE245  $1. ;
         format  IE246  $1. ;
         format  IE247  $1. ;
         format  IE248  $1. ;
         format  ITE24  $1. ;
         format  IE252  $1. ;
         format  IE253  $1. ;
         format  IE254  $1. ;
         format  IE255  $1. ;
         format  IE256  $1. ;
         format  IE257  $1. ;
         format  IE258  $1. ;
         format  ITE25  $1. ;
         format  IE262  $1. ;
         format  IE263  $1. ;
         format  IE264  $1. ;
         format  IE265  $1. ;
         format  IE266  $1. ;
         format  IE267  $1. ;
         format  IE268  $1. ;
         format  ITE26  $1. ;
         format  ISTE22  $1. ;
         format  ISTE23  $1. ;
         format  ISTE24  $1. ;
         format  ISTE25  $1. ;
         format  ISTE26  $1. ;
         format  ISTE27  $1. ;
         format  ISTE28  $1. ;
         format  ISTE2T  $1. ;
         format  IE3A11  $1. ;
         format  IE3A12  $1. ;
         format  IE3A13  $1. ;
         format  IE3A14  $1. ;
         format  IE3A2  $1. ;
         format  IE3A16  $1. ;
         format  IE3A1  $1. ;
         format  IE3B11  $1. ;
         format  IE3B12  $1. ;
         format  IE3B13  $1. ;
         format  IE3B14  $1. ;
         format  IE3B2  $1. ;
         format  IE3B16  $1. ;
         format  IE3B1  $1. ;
         format  ISTE3  $1. ;
         format  IE4A1  $1. ;
         format  IE4A2  $1. ;
         format  IE4B1  $1. ;
         format  IE4B2  $1. ;
         format  IE4C1  $1. ;
         format  IE4C2  $1. ;
         format  IE4D  $1. ;
         format  IE4E1  $1. ;
         format  IE4E2  $1. ;
         format  ISTE4  $1. ;
         format  ITE5  $1. ;
         format  IE61  $1. ;
         format  IE62  $1. ;
         format  IE63  $1. ;
         format  ISTE6  $1. ;
         format  IE7A1  $1. ;
         format  IE7A2  $1. ;
         format  ISTE7  $1. ;
         format  IE81  $1. ;
         format  IE82  $1. ;
         format  IE9A  $1. ;
         format  IE9B  $1. ;
         format  IE9C  $1. ;
         format  IE9D  $1. ;
         format  IE91  $1. ;
         format  ISTE9  $1. ;
         format  ITE10  $1. ;
         format  ITE11  $1. ;
         format  IX12C  $1. ;
         format  IX12D  $1. ;
         format  IX12E  $1. ;
         format  IX12F  $1. ;
         format  ITX12  $1. ;
         format  INCE13  $1. ;
         format  IADA  $1. ;
         format  IA14A  $1. ;
         format  IA14B  $1. ;
         format  IPPE15  $1. ;
         format  IMEMBR20  $1. ;
         format  ICE1  $1. ;
         format  ICE2  $1. ;
         format  IAR1  $1. ;
         format  IAR1A  $1. ;
         format  IAR1B  $1. ;
         format  IAR2  $1. ;
         format  IAR2A  $1. ;
         format  IAR3  $1. ;
         format  IAR6  $1. ;
         format  IAR6A  $1. ;
         format  IAR7  $1. ;
         format  IAR8  $1. ;
         format  IAE1  $1. ;
         format  IAE2  $1. ;
         format  IAE3  $1. ;
         format  IAE4  $1. ;
         format  IAE5  $1. ;
         format  IAE6  $1. ;
         format  IAE7  $1. ;
         format  IAE8  $1. ;
 
         label 
               SURVYEAR =    'Fiscal Year of Survey (2021)'
               FIPS     =    'American National Standards Institute (ANSI) State Code'
               STABR    =    'Postal State Abbreviation Code'
               STNAME   =    'Name of the State or Territory'
               R1A      =    'Local Revenues Property Tax'
               R1B      =    'Local Revenues Nonproperty Tax'
               R1C      =    'Local Revenues Local Government Property Tax'
               R1D      =    'Local Revenues Local Government Nonproperty Tax'
               R1E      =    'Local Revenues Individual Tuition'
               R1F      =    'Local Revenues Tuition from LEAs'
               R1G      =    'Local Revenues Transportation Fees from Individual'
               R1H      =    'Local Revenues Transportation Fees from LEAs'
               R1I      =    'Local Revenues Earnings on Investments'
               R1J      =    'Local Revenues Food Service'
               R1K      =    'Local Revenues District Activities'
               R1L      =    'Local Revenues Other Revenues'
               R1M      =    'Local Revenues Textbook Revenues'
               R1N      =    'Local Revenues Summer School'
               STR1     =    'Local Revenues Subtotal'
               R2       =    'Intermediate Revenues'
               R3       =    'State Revenues'
               R4A      =    'Federal Revenues Direct Grants'
               R4B      =    'Federal Revenues thru State'
               R4C      =    'Federal Revenues thru Intermediate Agencies'
               R4D      =    'Federal Revenues Other Sources'
               STR4     =    'Federal Revenues Subtotal'
               R5       =    'Revenues from Other Sources'
               TR       =    'Total Revenues from All Sources'
               E11      =    'Instructional Expenditures Salaries'
               E12      =    'Instructional Expenditures Employee Benefits'
               E13      =    'Instructional Expenditures Purchased Services'
               E14      =    'Instructional Expenditures Tuition to Private and Out-Of-State Schools'
               E15      =    'Instructional Expenditures Tuition to Other LEAs In-State'
               E16      =    'Instructional Expenditures Supplies'
               E17      =    'Instructional Expenditures Property'
               E18      =    'Instructional Expenditures Other'
               STE1     =    'Instructional Expenditures Subtotal'
               E11A     =    'Teacher Salaries Regular Programs'
               E11B     =    'Teacher Salaries Special Education Programs'
               E11C     =    'Teacher Salaries Vocational Education Programs'
               E11D     =    'Teacher Salaries Other Education Programs'
               E2       =    'Instructional Expenditures Textbooks'
               E212     =    'Support Expenditures Salaries Student Support Services'
               E213     =    'Support Expenditures Salaries Instructional Staff Support'
               E214     =    'Support Expenditures Salaries General Administration'
               E215     =    'Support Expenditures Salaries School Administration'
               E216     =    'Support Expenditures Salaries Operation & Maintenance'
               E217     =    'Support Expenditures Salaries Pupil Transportation'
               E218     =    'Support Expenditures Salaries Other Services'
               TE21     =    'Support Expenditures Salaries Subtotal'
               E222     =    'Support Expenditures Employee Benefits Student Support Services'
               E223     =    'Support Expenditures Employee Benefits Instructional Staff Support'
               E224     =    'Support Expenditures Employee Benefits General Administration'
               E225     =    'Support Expenditures Employee Benefits School Administration'
               E226     =    'Support Expenditures Employee Benefits Operation & Maintenance'
               E227     =    'Support Expenditures Employee Benefits Pupil Transportation'
               E228     =    'Support Expenditures Employee Benefits Other Services'
               TE22     =    'Support Expenditures Employee Benefits Subtotal'
               E232     =    'Support Expenditures Purchased Services Student Support Services'
               E233     =    'Support Expenditures Purchased Services Instructional Staff Support'
               E234     =    'Support Expenditures Purchased Services General Administration'
               E235     =    'Support Expenditures Purchased Services School Administration'
               E236     =    'Support Expenditures Purchased Services Operation & Maintenance'
               E237     =    'Support Expenditures Purchased Services Pupil Transportation'
               E238     =    'Support Expenditures Purchased Services Other Services'
               TE23     =    'Support Expenditures Purchased Services Subtotal'
               E242     =    'Support Expenditures Supplies Student Support Services'
               E243     =    'Support Expenditures Supplies Instructional Staff Support'
               E244     =    'Support Expenditures Supplies General Administration'
               E245     =    'Support Expenditures Supplies School Administration'
               E246     =    'Support Expenditures Supplies Operation & Maintenance'
               E247     =    'Support Expenditures Supplies Pupil Transportation'
               E248     =    'Support Expenditures Supplies Other Services'
               TE24     =    'Support Expenditures Supplies Subtotal'
               E252     =    'Support Expenditures Property Student Support Services'
               E253     =    'Support Expenditures Property Instructional Staff Support'
               E254     =    'Support Expenditures Property General Administration'
               E255     =    'Support Expenditures Property School Administration'
               E256     =    'Support Expenditures Property Operation & Maintenance'
               E257     =    'Support Expenditures Property Pupil Transportation'
               E258     =    'Support Expenditures Property Other Services'
               TE25     =    'Support Expenditures Property Subtotal'
               E262     =    'Support Expenditures Other Student Support Services'
               E263     =    'Support Expenditures Other Instructional Staff Support'
               E264     =    'Support Expenditures Other General Administration'
               E265     =    'Support Expenditures Other School Administration'
               E266     =    'Support Expenditures Other Operation & Maintenance'
               E267     =    'Support Expenditures Other Pupil Transportation'
               E268     =    'Support Expenditures Other Other Services'
               TE26     =    'Support Expenditures Other Subtotal'
               STE22    =    'Support Expenditures Subtotal Student Support Services'
               STE23    =    'Support Expenditures Subtotal Instructional Staff Support'
               STE24    =    'Support Expenditures Subtotal General Administration'
               STE25    =    'Support Expenditures Subtotal School Administration'
               STE26    =    'Support Expenditures Subtotal Operation & Maintenance'
               STE27    =    'Support Expenditures Subtotal Pupil Transportation'
               STE28    =    'Support Expenditures Subtotal Other Services'
               STE2T    =    'Support Expenditures Total Support Services'
               E3A11    =    'Noninstructional Services Food Services Salaries'
               E3A12    =    'Noninstructional Services Food Services Employee Benefits'
               E3A13    =    'Noninstructional Services Food Services Purchased Services'
               E3A14    =    'Noninstructional Services Food Services Supplies'
               E3A2     =    'Noninstructional Services Food Services Property'
               E3A16    =    'Noninstructional Services Food Services Other'
               E3A1     =    'Noninstructional Services Food Services Subtotal'
               E3B11    =    'Noninstructional Services Enterprise Salaries'
               E3B12    =    'Noninstructional Services Enterprise Employee Benefits'
               E3B13    =    'Noninstructional Services Enterprise Purchased Services'
               E3B14    =    'Noninstructional Services Enterprise Supplies'
               E3B2     =    'Noninstructional Services Enterprise Property'
               E3B16    =    'Noninstructional Services Enterprise Other'
               E3B1     =    'Noninstructional Services Enterprise Subtotal'
               STE3     =    'Noninstructional Services Total'
               E4A1     =    'Direct Program Support Textbooks'
               E4A2     =    'Direct Program Support Textbooks (Property)'
               E4B1     =    'Direct Program Support Transportation'
               E4B2     =    'Direct Program Support Transportation (Property)'
               E4C1     =    'Direct Program Support Employee Benefits'
               E4C2     =    'Direct Program Support Employee Benefits (Property)'
               E4D      =    'Direct Program Support Private School Student'
               E4E1     =    'Direct Program Support Other'
               E4E2     =    'Direct Program Support Other (Property)'
               STE4     =    'Direct Program Support Subtotal'
               TE5      =    'Current Expenditures'
               E61      =    'Facilities Acquisition Nonproperty'
               E62      =    'Facilities Acquisition Property (Land & Buildings)'
               E63      =    'Facilities Acquisition Property (Equipment)'
               STE6     =    'Facilities Acquisition Nonproperty & Property Total'
               E7A1     =    'Other Use Debt Service Interest'
               E7A2     =    'Other Use Debt Service Redemption'
               STE7     =    'Other Use Debt Service Subtotal'
               E81      =    'Community Service Nonproperty'
               E82      =    'Community Service Property'
               E9A      =    'Direct Cost Program Nonpublic School'
               E9B      =    'Direct Cost Program Adult Education'
               E9C      =    'Direct Cost Program Community College'
               E9D      =    'Direct Cost Program Other'
               E91      =    'Direct Cost Program Property'
               STE9     =    'Direct Cost Program Subtotal'
               TE10     =    'Property Total'
               TE11     =    'Total Expenditures for Education'
               X12C     =    'Exclusion for PL 114 95 Title I'
               X12D     =    'Exclusion for PL 114 95 Title I Carryover'
               X12E     =    'Exclusion for Title V, Part A'
               X12F     =    'Exclusion for Title V, Part A Carryover'
               TX12     =    'Total Exclusion for PL 114 95'
               NCE13    =    'Net Current Expenditures'
               ADA      =    'Average Daily Attendance (State and NCES Definition)'
               A14A     =    'Average Daily Attendance (State Definition)'
               A14B     =    'Average Daily Attendance (NCES Definition)'
               PPE15    =    'Per Pupil Expenditures'
               MEMBR20  =    'Total Student Membership'
               CE1      =    'Current Expenditures Paid from State and Local Funds'
               CE2      =    'Current Expenditures Paid from Federal Funds'
               AR1      =    'CARES Act Revenues ESSER I Fund'
               AR1A     =    'CRRSA Revenues ESSER II Fund'
               AR1B     =    'ARP Act ARP ESSER Fund'
               AR2      =    'CARES Act Revenues GEER Fund'
               AR2A     =    'CRRSA GEER II Fund'
               AR3      =    'CARES Act Revenues ESF-RWP'
               AR6      =    'CARES Act Revenues Coronavirus Relief Fund'
               AR6A     =    'ARP Act Coronavirus SLFR Funds'
               AR7      =    'CARES Act Revenues ESF Outlying Areas-SEA'
               AR8      =    'CARES Act Revenues ESF Outlying Areas-GOV'
               AE1      =    'Current Expenditures from COVID-19 Federal Assistance Funds'
               AE2      =    'Instructional Expenditures from COVID-19 Federal Assistance Funds'
               AE3      =    'Support Services Expenditures from COVID-19 Federal Assistance Funds'
               AE4      =    'Capital Outlay Expenditures from COVID-19 Federal Assistance Funds'
               AE5      =    'Technology Supplies & Purchased Services Expenditures from COVID-19 Federal Assistance Funds'
               AE6      =    'Technology Equipment Expenditures from COVID-19 Federal Assistance Funds'
               AE7      =    'Support Services, Operations & Maintenance Expenditures from COVID-19 Federal Assistance Funds'
               AE8      =    'Food Services Operations Expenditures from COVID-19 Federal Assistance Funds'
               IR1A     =    'Imp Flag Local Revenues Property Tax'
               IR1B     =    'Imp Flag Local Revenues Nonproperty Tax'
               IR1C     =    'Imp Flag Local Revenues Local Government Property Tax'
               IR1D     =    'Imp Flag Local Revenues Local Government Nonproperty Tax'
               IR1E     =    'Imp Flag Local Revenues Individual Tuition'
               IR1F     =    'Imp Flag Local Revenues Tuition from LEAs'
               IR1G     =    'Imp Flag Local Revenues Transportation Fees from Individual'
               IR1H     =    'Imp Flag Local Revenues Transportation Fees from LEAs'
               IR1I     =    'Imp Flag Local Revenues Earnings on Investments'
               IR1J     =    'Imp Flag Local Revenues Food Service'
               IR1K     =    'Imp Flag Local Revenues District Activities'
               IR1L     =    'Imp Flag Local Revenues Other Revenues'
               IR1M     =    'Imp Flag Local Revenues Textbook Revenues'
               IR1N     =    'Imp Flag Local Revenues Summer School'
               ISTR1    =    'Imp Flag Local Revenues Subtotal'
               IR2      =    'Imp Flag Intermediate Revenues'
               IR3      =    'Imp Flag State Revenues'
               IR4A     =    'Imp Flag Federal Revenues Direct Grants'
               IR4B     =    'Imp Flag Federal Revenues thru State'
               IR4C     =    'Imp Flag Federal Revenues thru Intermediate Agencies'
               IR4D     =    'Imp Flag Federal Revenues Other Sources'
               ISTR4    =    'Imp Flag Federal Revenues Subtotal'
               IR5      =    'Imp Flag Revenues from Other Sources'
               ITR      =    'Imp Flag Total Revenues from All Sources'
               IE11     =    'Imp Flag Instructional Expenditures Salaries'
               IE12     =    'Imp Flag Instructional Expenditures Employee Benefits'
               IE13     =    'Imp Flag Instructional Expenditures Purchased Services'
               IE14     =    'Imp Flag Instructional Expenditures Tuition to Private and Out-Of-State Schools'
               IE15     =    'Imp Flag Instructional Expenditures Tuition to Other LEAs In-State'
               IE16     =    'Imp Flag Instructional Expenditures Supplies'
               IE17     =    'Imp Flag Instructional Expenditures Property'
               IE18     =    'Imp Flag Instructional Expenditures Other'
               ISTE1    =    'Imp Flag Instructional Expenditures Subtotal'
               IE11A    =    'Imp Flag Teacher Salaries Regular Programs'
               IE11B    =    'Imp Flag Teacher Salaries Special Education Programs'
               IE11C    =    'Imp Flag Teacher Salaries Vocational Education Programs'
               IE11D    =    'Imp Flag Teacher Salaries Other Education Programs'
               IE2      =    'Imp Flag Instructional Expenditures Textbooks'
               IE212    =    'Imp Flag Support Expenditures Salaries Student Support Services'
               IE213    =    'Imp Flag Support Expenditures Salaries Instructional Staff Support'
               IE214    =    'Imp Flag Support Expenditures Salaries General Administration'
               IE215    =    'Imp Flag Support Expenditures Salaries School Administration'
               IE216    =    'Imp Flag Support Expenditures Salaries Operation & Maintenance'
               IE217    =    'Imp Flag Support Expenditures Salaries Pupil Transportation'
               IE218    =    'Imp Flag Support Expenditures Salaries Other Services'
               ITE21    =    'Imp Flag Support Expenditures Salaries Subtotal'
               IE222    =    'Imp Flag Support Expenditures Employee Benefits Student Support Services'
               IE223    =    'Imp Flag Support Expenditures Employee Benefits Instructional Staff Support'
               IE224    =    'Imp Flag Support Expenditures Employee Benefits General Administration'
               IE225    =    'Imp Flag Support Expenditures Employee Benefits School Administration'
               IE226    =    'Imp Flag Support Expenditures Employee Benefits Operation & Maintenance'
               IE227    =    'Imp Flag Support Expenditures Employee Benefits Pupil Transportation'
               IE228    =    'Imp Flag Support Expenditures Employee Benefits Other Services'
               ITE22    =    'Imp Flag Support Expenditures Employee Benefits Subtotal'
               IE232    =    'Imp Flag Support Expenditures Purchased Services Student Support Services'
               IE233    =    'Imp Flag Support Expenditures Purchased Services Instructional Staff Support'
               IE234    =    'Imp Flag Support Expenditures Purchased Services General Administration'
               IE235    =    'Imp Flag Support Expenditures Purchased Services School Administration'
               IE236    =    'Imp Flag Support Expenditures Purchased Services Operation & Maintenance'
               IE237    =    'Imp Flag Support Expenditures Purchased Services Pupil Transportation'
               IE238    =    'Imp Flag Support Expenditures Purchased Services Other Services'
               ITE23    =    'Imp Flag Support Expenditures Purchased Services Subtotal'
               IE242    =    'Imp Flag Support Expenditures Supplies Student Support Services'
               IE243    =    'Imp Flag Support Expenditures Supplies Instructional Staff Support'
               IE244    =    'Imp Flag Support Expenditures Supplies General Administration'
               IE245    =    'Imp Flag Support Expenditures Supplies School Administration'
               IE246    =    'Imp Flag Support Expenditures Supplies Operation & Maintenance'
               IE247    =    'Imp Flag Support Expenditures Supplies Pupil Transportation'
               IE248    =    'Imp Flag Support Expenditures Supplies Other Services'
               ITE24    =    'Imp Flag Support Expenditures Supplies Subtotal'
               IE252    =    'Imp Flag Support Expenditures Property Student Support Services'
               IE253    =    'Imp Flag Support Expenditures Property Instructional Staff Support'
               IE254    =    'Imp Flag Support Expenditures Property General Administration'
               IE255    =    'Imp Flag Support Expenditures Property School Administration'
               IE256    =    'Imp Flag Support Expenditures Property Operation & Maintenance'
               IE257    =    'Imp Flag Support Expenditures Property Pupil Transportation'
               IE258    =    'Imp Flag Support Expenditures Property Other Services'
               ITE25    =    'Imp Flag Support Expenditures Property Subtotal'
               IE262    =    'Imp Flag Support Expenditures Other Student Support Services'
               IE263    =    'Imp Flag Support Expenditures Other Instructional Staff Support'
               IE264    =    'Imp Flag Support Expenditures Other General Administration'
               IE265    =    'Imp Flag Support Expenditures Other School Administration'
               IE266    =    'Imp Flag Support Expenditures Other Operation & Maintenance'
               IE267    =    'Imp Flag Support Expenditures Other Pupil Transportation'
               IE268    =    'Imp Flag Support Expenditures Other Other Services'
               ITE26    =    'Imp Flag Support Expenditures Other Subtotal'
               ISTE22   =    'Imp Flag Support Expenditures Subtotal Student Support Services'
               ISTE23   =    'Imp Flag Support Expenditures Subtotal Instructional Staff Support'
               ISTE24   =    'Imp Flag Support Expenditures Subtotal General Administration'
               ISTE25   =    'Imp Flag Support Expenditures Subtotal School Administration'
               ISTE26   =    'Imp Flag Support Expenditures Subtotal Operation & Maintenance'
               ISTE27   =    'Imp Flag Support Expenditures Subtotal Pupil Transportation'
               ISTE28   =    'Imp Flag Support Expenditures Subtotal Other Services'
               ISTE2T   =    'Imp Flag Support Expenditures Total Support Services'
               IE3A11   =    'Imp Flag Noninstructional Services Food Services Salaries'
               IE3A12   =    'Imp Flag Noninstructional Services Food Services Employee Benefits'
               IE3A13   =    'Imp Flag Noninstructional Services Food Services Purchased Services'
               IE3A14   =    'Imp Flag Noninstructional Services Food Services Supplies'
               IE3A2    =    'Imp Flag Noninstructional Services Food Services Property'
               IE3A16   =    'Imp Flag Noninstructional Services Food Services Other'
               IE3A1    =    'Imp Flag Noninstructional Services Food Services Subtotal'
               IE3B11   =    'Imp Flag Noninstructional Services Enterprise Salaries'
               IE3B12   =    'Imp Flag Noninstructional Services Enterprise Employee Benefits'
               IE3B13   =    'Imp Flag Noninstructional Services Enterprise Purchased Services'
               IE3B14   =    'Imp Flag Noninstructional Services Enterprise Supplies'
               IE3B2    =    'Imp Flag Noninstructional Services Enterprise Property'
               IE3B16   =    'Imp Flag Noninstructional Services Enterprise Other'
               IE3B1    =    'Imp Flag Noninstructional Services Enterprise Subtotal'
               ISTE3    =    'Imp Flag Noninstructional Services Total'
               IE4A1    =    'Imp Flag Direct Program Support Textbooks'
               IE4A2    =    'Imp Flag Direct Program Support Textbooks (Property)'
               IE4B1    =    'Imp Flag Direct Program Support Transportation'
               IE4B2    =    'Imp Flag Direct Program Support Transportation (Property)'
               IE4C1    =    'Imp Flag Direct Program Support Employee Benefits'
               IE4C2    =    'Imp Flag Direct Program Support Employee Benefits (Property)'
               IE4D     =    'Imp Flag Direct Program Support Private School Student'
               IE4E1    =    'Imp Flag Direct Program Support Other'
               IE4E2    =    'Imp Flag Direct Program Support Other (Property)'
               ISTE4    =    'Imp Flag Direct Program Support Subtotal'
               ITE5     =    'Imp Flag Current Expenditures'
               IE61     =    'Imp Flag Facilities Acquisition Nonproperty'
               IE62     =    'Imp Flag Facilities Acquisition Property (Land & Buildings)'
               IE63     =    'Imp Flag Facilities Acquisition Property (Equipment)'
               ISTE6    =    'Imp Flag Facilities Acquisition Nonproperty & Property Total'
               IE7A1    =    'Imp Flag Other Use Debt Service Interest'
               IE7A2    =    'Imp Flag Other Use Debt Service Redemption'
               ISTE7    =    'Imp Flag Other Use Debt Service Subtotal'
               IE81     =    'Imp Flag Community Service Nonproperty'
               IE82     =    'Imp Flag Community Service Property'
               IE9A     =    'Imp Flag Direct Cost Program Nonpublic School'
               IE9B     =    'Imp Flag Direct Cost Program Adult Education'
               IE9C     =    'Imp Flag Direct Cost Program Community College'
               IE9D     =    'Imp Flag Direct Cost Program Other'
               IE91     =    'Imp Flag Direct Cost Program Property'
               ISTE9    =    'Imp Flag Direct Cost Program Subtotal'
               ITE10    =    'Imp Flag Property Total'
               ITE11    =    'Imp Flag Total Expenditures for Education'
               IX12C    =    'Imp Flag Exclusion for PL 114 95 Title I'
               IX12D    =    'Imp Flag Exclusion for PL 114 95 Title I Carryover'
               IX12E    =    'Imp Flag Exclusion for Title V, Part A'
               IX12F    =    'Imp Flag Exclusion for Title V, Part A Carryover'
               ITX12    =    'Imp Flag Total Exclusion for PL 114 95'
               INCE13   =    'Imp Flag Net Current Expenditures'
               IADA     =    'Imp Flag Average Daily Attendance (State and NCES Definition)'
               IA14A    =    'Imp Flag Average Daily Attendance (State Definition)'
               IA14B    =    'Imp Flag Average Daily Attendance (NCES Definition)'
               IPPE15   =    'Imp Flag Per Pupil Expenditures'
               IMEMBR20 =    'Imp Flag Total Student Membership'
               ICE1     =    'Imp Flag Current Expenditures Paid from State and Local Funds'
               ICE2     =    'Imp Flag Current Expenditures Paid from Federal Funds'
               IAR1     =    'Imp Flag CARES Act Revenues ESSER I Fund'
               IAR1A    =    'Imp Flag CRRSA Revenues ESSER II Fund'
               IAR1B    =    'Imp Flag ARP Act ARP ESSER Fund'
               IAR2     =    'Imp Flag CARES Act Revenues GEER Fund'
               IAR2A    =    'Imp Flag CRRSA GEER II Fund'
               IAR3     =    'Imp Flag CARES Act Revenues ESF-RWP'
               IAR6     =    'Imp Flag CARES Act Revenues Coronavirus Relief Fund'
               IAR6A    =    'Imp Flag ARP Act Coronavirus SLFR Funds'
               IAR7     =    'Imp Flag CARES Act Revenues ESF Outlying Areas-SEA'
               IAR8     =    'Imp Flag CARES Act Revenues ESF Outlying Areas-GOV'
               IAE1     =    'Imp Flag Current Expenditures from COVID-19 Federal Assistance Funds'
               IAE2     =    'Imp Flag Instructional Expenditures from COVID-19 Federal Assistance Funds'
               IAE3     =    'Imp Flag Support Services Expenditures from COVID-19 Federal Assistance Funds'
               IAE4     =    'Imp Flag Capital Outlay Expenditures from COVID-19 Federal Assistance Funds'
               IAE5     =    'Imp Flag Technology Supplies & Purchased Services Expenditures from COVID-19 Federal Assistance Fund'
               IAE6     =    'Imp Flag Technology Equipment Expenditures from COVID-19 Federal Assistance Funds'
               IAE7     =    'Imp Flag Support Services, Operations & Maintenance Expenditures from COVID-19 Federal Assistance Fu'
               IAE8     =    'Imp Flag Food Services Operations Expenditures from COVID-19 Federal Assistance Funds'
;
 
         input 
               SURVYEAR   
               FIPS  $
               STABR  $
               STNAME  $
               R1A   
               R1B   
               R1C   
               R1D   
               R1E   
               R1F   
               R1G   
               R1H   
               R1I   
               R1J   
               R1K   
               R1L   
               R1M   
               R1N   
               STR1   
               R2   
               R3   
               R4A   
               R4B   
               R4C   
               R4D   
               STR4   
               R5   
               TR   
               E11   
               E12   
               E13   
               E14   
               E15   
               E16   
               E17   
               E18   
               STE1   
               E11A   
               E11B   
               E11C   
               E11D   
               E2   
               E212   
               E213   
               E214   
               E215   
               E216   
               E217   
               E218   
               TE21   
               E222   
               E223   
               E224   
               E225   
               E226   
               E227   
               E228   
               TE22   
               E232   
               E233   
               E234   
               E235   
               E236   
               E237   
               E238   
               TE23   
               E242   
               E243   
               E244   
               E245   
               E246   
               E247   
               E248   
               TE24   
               E252   
               E253   
               E254   
               E255   
               E256   
               E257   
               E258   
               TE25   
               E262   
               E263   
               E264   
               E265   
               E266   
               E267   
               E268   
               TE26   
               STE22   
               STE23   
               STE24   
               STE25   
               STE26   
               STE27   
               STE28   
               STE2T   
               E3A11   
               E3A12   
               E3A13   
               E3A14   
               E3A2   
               E3A16   
               E3A1   
               E3B11   
               E3B12   
               E3B13   
               E3B14   
               E3B2   
               E3B16   
               E3B1   
               STE3   
               E4A1   
               E4A2   
               E4B1   
               E4B2   
               E4C1   
               E4C2   
               E4D   
               E4E1   
               E4E2   
               STE4   
               TE5   
               E61   
               E62   
               E63   
               STE6   
               E7A1   
               E7A2   
               STE7   
               E81   
               E82   
               E9A   
               E9B   
               E9C   
               E9D   
               E91   
               STE9   
               TE10   
               TE11   
               X12C   
               X12D   
               X12E   
               X12F   
               TX12   
               NCE13   
               ADA   
               A14A   
               A14B   
               PPE15   
               MEMBR20   
               CE1   
               CE2   
               AR1   
               AR1A   
               AR1B   
               AR2   
               AR2A   
               AR3   
               AR6   
               AR6A   
               AR7   
               AR8   
               AE1   
               AE2   
               AE3   
               AE4   
               AE5   
               AE6   
               AE7   
               AE8   
               IR1A  $
               IR1B  $
               IR1C  $
               IR1D  $
               IR1E  $
               IR1F  $
               IR1G  $
               IR1H  $
               IR1I  $
               IR1J  $
               IR1K  $
               IR1L  $
               IR1M  $
               IR1N  $
               ISTR1  $
               IR2  $
               IR3  $
               IR4A  $
               IR4B  $
               IR4C  $
               IR4D  $
               ISTR4  $
               IR5  $
               ITR  $
               IE11  $
               IE12  $
               IE13  $
               IE14  $
               IE15  $
               IE16  $
               IE17  $
               IE18  $
               ISTE1  $
               IE11A  $
               IE11B  $
               IE11C  $
               IE11D  $
               IE2  $
               IE212  $
               IE213  $
               IE214  $
               IE215  $
               IE216  $
               IE217  $
               IE218  $
               ITE21  $
               IE222  $
               IE223  $
               IE224  $
               IE225  $
               IE226  $
               IE227  $
               IE228  $
               ITE22  $
               IE232  $
               IE233  $
               IE234  $
               IE235  $
               IE236  $
               IE237  $
               IE238  $
               ITE23  $
               IE242  $
               IE243  $
               IE244  $
               IE245  $
               IE246  $
               IE247  $
               IE248  $
               ITE24  $
               IE252  $
               IE253  $
               IE254  $
               IE255  $
               IE256  $
               IE257  $
               IE258  $
               ITE25  $
               IE262  $
               IE263  $
               IE264  $
               IE265  $
               IE266  $
               IE267  $
               IE268  $
               ITE26  $
               ISTE22  $
               ISTE23  $
               ISTE24  $
               ISTE25  $
               ISTE26  $
               ISTE27  $
               ISTE28  $
               ISTE2T  $
               IE3A11  $
               IE3A12  $
               IE3A13  $
               IE3A14  $
               IE3A2  $
               IE3A16  $
               IE3A1  $
               IE3B11  $
               IE3B12  $
               IE3B13  $
               IE3B14  $
               IE3B2  $
               IE3B16  $
               IE3B1  $
               ISTE3  $
               IE4A1  $
               IE4A2  $
               IE4B1  $
               IE4B2  $
               IE4C1  $
               IE4C2  $
               IE4D  $
               IE4E1  $
               IE4E2  $
               ISTE4  $
               ITE5  $
               IE61  $
               IE62  $
               IE63  $
               ISTE6  $
               IE7A1  $
               IE7A2  $
               ISTE7  $
               IE81  $
               IE82  $
               IE9A  $
               IE9B  $
               IE9C  $
               IE9D  $
               IE91  $
               ISTE9  $
               ITE10  $
               ITE11  $
               IX12C  $
               IX12D  $
               IX12E  $
               IX12F  $
               ITX12  $
               INCE13  $
               IADA  $
               IA14A  $
               IA14B  $
               IPPE15  $
               IMEMBR20  $
               ICE1  $
               ICE2  $
               IAR1  $
               IAR1A  $
               IAR1B  $
               IAR2  $
               IAR2A  $
               IAR3  $
               IAR6  $
               IAR6A  $
               IAR7  $
               IAR8  $
               IAE1  $
               IAE2  $
               IAE3  $
               IAE4  $
               IAE5  $
               IAE6  $
               IAE7  $
               IAE8  $
;
        if _ERROR_ then call symputx('_EFIERR_',1);  /* set ERROR detection macro variable */
     run;
